/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.ai;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.entity.Dog;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class DogProtestSitOrderGoal
extends Goal {
    private final int MIN_TOLERABLE_SPAM_TIME = 3;
    private Dog dog;
    private int lastOrderedToSitTick0;
    private int spamTime = 0;
    private int spamTimeMax = 3;
    private int stopAnimTick;

    public DogProtestSitOrderGoal(Dog dog) {
        this.dog = dog;
        this.spamTimeMax = 3 + dog.m_217043_().m_188503_(4);
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        this.updateDetectSpamSit();
        if (!this.dog.m_20096_()) {
            return false;
        }
        if (this.dog.m_20160_()) {
            return false;
        }
        if (this.spamTime >= this.spamTimeMax) {
            this.spamTime = 0;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.dog.setAnim(DogAnimation.PROTEST);
        if (!this.dog.m_21825_()) {
            this.dog.setSitAnim(DogAnimation.NONE);
        }
        this.dog.setProtesting(true);
        this.dog.m_21839_(true);
        this.stopAnimTick = this.dog.f_19797_ + DogAnimation.PROTEST.getLengthTicks();
    }

    public void m_8037_() {
        LivingEntity owner = this.dog.m_269323_();
        if (owner == null) {
            return;
        }
        if (owner.m_20280_((Entity)this.dog) > 25.0) {
            return;
        }
        this.dog.m_21563_().m_24960_((Entity)owner, 10.0f, (float)this.dog.m_8132_());
    }

    public void m_8041_() {
        if (this.dog.getAnim() == DogAnimation.PROTEST) {
            this.dog.setAnim(DogAnimation.NONE);
        }
        if (this.dog.getSitAnim() == DogAnimation.NONE) {
            this.dog.setSitAnim(null);
        }
        this.dog.setProtesting(false);
        this.spamTimeMax = 3 + this.dog.m_217043_().m_188503_(4);
    }

    public boolean m_8045_() {
        return this.dog.m_21827_() && this.dog.f_19797_ <= this.stopAnimTick;
    }

    private void updateDetectSpamSit() {
        if (this.dog.lastOrderedToSitTick != this.lastOrderedToSitTick0) {
            int interval = Math.abs(this.dog.lastOrderedToSitTick - this.lastOrderedToSitTick0);
            this.spamTime = interval <= this.getSpamInterval() ? ++this.spamTime : 0;
            this.lastOrderedToSitTick0 = this.dog.lastOrderedToSitTick;
        }
    }

    private int getSpamInterval() {
        return 45;
    }
}

